// Copyright (C) Mikko Apo (apo@iki.fi)
// The following code may be used to write free software
// if credit is given to the original author.
// Using it for anything else is not allowed without permission
// from the author.

#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <string.h>
#include "../mdk.h"

#define COMMAND_STRING "About..."
#define MACHINE_NAME "cheapo do-nothing"
#define SHORT_NAME "do-nothing"
#define MACHINE_AUTHOR "Mikko Apo (apo@iki.fi)"
#define MAX_TRACKS		0
#define MIN_TRACKS		0
#define NUMGLOBALPARAMETERS 0
#define NUMTRACKPARAMETERS 0
#define NUMATTRIBUTES 0
#define __VERSION__ "1.0"

// Machine's info

CMachineInfo const MacInfo = 
{
	MT_EFFECT,MI_VERSION,MIF_DOES_INPUT_MIXING,MIN_TRACKS,MAX_TRACKS,
	NUMGLOBALPARAMETERS,NUMTRACKPARAMETERS,NULL,NUMATTRIBUTES,NULL,
#ifdef _DEBUG
	MACHINE_NAME" [DEBUG]"
#else
	MACHINE_NAME
#endif
	,SHORT_NAME,MACHINE_AUTHOR,COMMAND_STRING
};


class miex : public CMDKMachineInterfaceEx
{

};

class mi : public CMDKMachineInterface
{
public:
	mi();

	virtual void Command(int const i);
//	virtual void Tick();
//	virtual char const *DescribeValue(int const param, int const value);

	virtual void MDKInit(CMachineDataInput * const pi);
	virtual bool MDKWork(float *psamples, int numsamples, int const mode);
	virtual bool MDKWorkStereo(float *psamples, int numsamples, int const mode);
	virtual void MDKSave(CMachineDataOutput * const po) { }

	public:
	virtual CMDKMachineInterfaceEx *GetEx() { return &ex; }
	virtual void OutputModeChanged(bool stereo) {};

	public:
	miex ex;

private:

};


DLL_EXPORTS

mi::mi()
{
}

void mi::Command(int const i)
{
	static char txt[500];
	switch(i)
	{
	case 0:
		pCB->MessageBox(MACHINE_NAME"\n\nBuild date: "__DATE__"\nVersion: "__VERSION__"\nCoded by: "MACHINE_AUTHOR"\n\nCheck out http://www.iki.fi/apo/buzz/\nfor more buzz stuff.\n\nExcellent skin made by Hymax.");
		break;
	}

}


void mi::MDKInit(CMachineDataInput * const pi)
{
}

bool mi::MDKWorkStereo(float *psamples, int numsamples, int const mode)
{
	if ((mode==WM_WRITE)||(mode==WM_NOIO))
	{
		return false;
	}

	return true;
}

bool mi::MDKWork(float *psamples, int numsamples, int const mode)
{
	if ((mode==WM_WRITE)||(mode==WM_NOIO))
	{
		return false;
	}

	return true;
}
